<?php

namespace MGModule\ServerAllocator\libraries\classes;

/**
 * @author Mariusz Miodowski <mariusz@modulesgarden.com>
 * @title Wesoła Twórczość
 * @desciption Co złego to nie ja
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

class MG_XML2Array
{
    private $tags       =   array();
    
    private $tree       =   array();
    
    private $current    =   array();
    
    private $level      =   0;
    
    private $parents    =   array();
    
    public function __construct()
    {
        $this->current  =   &$this->tree;
    }
    
    public function convert($xml)
    {
        if(!$xml)
        {
            throw new \Exception("XML not specified");
        }
        
        
        if(!function_exists('xml_parser_create')) 
        {
            throw new \Exception("function xml_parser_create does not exists");
        }
        
        $parser = xml_parser_create();
        xml_parser_set_option($parser, XML_OPTION_TARGET_ENCODING, 'UTF-8');
        xml_parser_set_option($parser, XML_OPTION_CASE_FOLDING, 0 );
        xml_parser_set_option($parser, XML_OPTION_SKIP_WHITE, 1 );
        xml_parse_into_struct($parser, trim($xml), $this->tags );
        xml_parser_free( $parser );

        if(!$this->tags)
        {
            return array();
        }
        
        foreach($this->tags as $tag)
        {
            switch($tag['type'])
            {
                case 'open':
                    $this->_openTag($tag['tag'], isset($tag['attributes']) ? $tag['attributes'] : array());
                    break;
                
                case 'close':
                    $this->_closeTag($tag['tag']);
                    break;
                
                case 'complete':
                    $this->_addTag($tag['tag'], isset($tag['value']) ? $tag['value'] : '', isset($tag['attributes']) ? $tag['attributes'] : array());
                    break;
            }
        }
        
        return $this->tree;
    }
    
    private function _openTag($tag, $attrs = array())
    {
        //Add tag to array
        $this->current[$tag]            =   array();
        //Has any attributes?
        if($attrs)
        {
            $this->current[$tag]['@attr']  =   $attrs;
        }
        
        //Move current tag to parents. It will be user for new tags
        $this->parents[$this->level]    =   &$this->current;
        $this->current                  =   &$this->current[$tag];
        
        //Level Up
        $this->level++; 
    }
    
    private function _closeTag($tag)
    {
        unset($this->parents[$this->level]);
        $this->level--;
        
        $this->current  =   &$this->parents[$this->level];   
    }
    
    private function _addTag($tag, $value, $attrs = array())
    {
        $arr['val'] =   $value;
        if($attrs)
        {
            $arr['@attr']   =   $attrs;
        }
        
        $this->current[$tag][]  = $arr;
    }
    
    public function __get($key)
    {
        if(isset($this->tree[$key]))
        {
            if(count($this->tree[$key]) == 1 && isset($this->tree[$key][0]['val']))
            {
                return $this->tree[$key][0]['val'];
            }
            else
            {
                $xml = new MG_XML2Array();
                $xml->tree = $this->tree[$key];

                return $xml;
            }
        }
        else
        {
            throw new \Exception("Tag ".$key." not found");
        }
    }
    
    public function getTree()
    {
        return $this->tree;
    }
    
    public function getAttr($attr)
    {
        if($this->tree['@attr'][$attr])
        {
            return $this->tree['@attr'][$attr];
        }
        elseif(count($this->tree) == 1 && $this->tree[0]['@attr'][$attr])
        {
            return $this->tree[0]['@attr'][$attr];
        }
        
        return false;
    }
    
    public function getVal()
    {
        if($this->tree['val'])
        {
            return $this->tree['val'];
        }
        elseif(count($this->tree) == 1 && $this->tree[0]['val'])
        {
            return $this->tree[0]['val'];
        }
        
        return false;
    }
}