<?php

namespace MGModule\ServerAllocator\libraries\classes;
use MGModule\ServerAllocator\libraries\classes as classes;

class MG_Lang
{
    private $lang_dir   =   '';
    
    private $lang       =   array();
    
    public function __construct($lang_dir = '')
    {
        if($lang_dir)
        {
            $this->lang_dir =   $lang_dir;
        }
        else
        {
            $tree = explode(DIRECTORY_SEPARATOR, dirname(__FILE__));
            while($tree)
            {
                $path = implode(DIRECTORY_SEPARATOR, $tree);
                if(is_dir($path.DIRECTORY_SEPARATOR.'lang'))
                {
                    $this->lang_dir = $path;
                    break;
                }
                array_pop($tree);
            }
        }
        
        $language = '';
        if(isset($_SESSION['language'])) // GET LANG FROM SESSION
        { 
            $language = strtolower($_SESSION['language']);
        }
        elseif (isset($_SESSION['uid']))
        {
            $qResult = classes\PDOWrapper::query("SELECT language FROM tblclients WHERE id = " . $_SESSION['uid']);
            $row = classes\PDOWrapper::fetch_assoc($qResult);
            if ($row['language']) 
            {
                $language = strtolower($row['language']);
            }
        }
        elseif(isset($_SESSION['uid']))
        {
            $qResult = classes\PDOWrapper::query("SELECT language FROM tblclients WHERE id = ".$_SESSION['uid']);
            $row = classes\PDOWrapper::fetch_assoc($qResult); 
            if($row['language'])
            {
                $language = strtolower($row['language']);
            }
        }

        if(!$language)
        {
            $qResult = classes\PDOWrapper::query("SELECT value FROM tblconfiguration WHERE setting = 'language' LIMIT 1");
            if(classes\PDOWrapper::num_rows($qResult))
            {
                $row = classes\PDOWrapper::fetch_assoc($qResult);
                $language = strtolower($row['value']);
            }
        }

        if(!$language)
        {
            $language = 'english';
        }

        if(!file_exists($this->lang_dir.DIRECTORY_SEPARATOR.$language.'.php'))
        {
            $language = 'english';
        }
        //Load File
	if(file_exists($this->lang_dir.DIRECTORY_SEPARATOR.$language.'.php'))
        {
	    include $this->lang_dir.DIRECTORY_SEPARATOR.$language.'.php';
	} 
	else 
	{
	    return;
	}
        //Set Lang
        if(isset($LANG)) 
        {
            $this->lang = $LANG;
        }
    }
    
    
    public function translate($key)
    {
        if(isset($this->lang[$key]))
        {
            return $this->lang[$key];
        }
        
        return $key;
    }
    
    public function getLang()
    {
        return $this->lang;
    }
}
