<?php

namespace MGModule\ServerAllocator\libraries\classes;
use \MGModule\ServerAllocator\libraries\classes\PDOWrapper;

if(!class_exists('MGModule\ServerAllocator\libraries\classes\MG_DB'))
{
class MG_DB
{
    /**
     * Run query
     * @param type $query
     * @param type $params
     * @return type
     * @throws Exception
     */
    public function query($query, $params = array()) 
    {
        $sql_query = PDOWrapper::query($query, $params);

        $err = PDOWrapper::errorInfo();
        if(!$sql_query && $err) 
        {
            throw new \Exception($err);
        }
        
        return ($sql_query);
    }
    
    /**
     * Get row
     * @param type $query
     * @param type $params
     * @return boolean
     */
    public function row($query, $params = array())
    {
        $qResult = $this->query($query, $params);
        if($qResult)
        {
            $row = PDOWrapper::fetch_assoc($qResult);
            
            return $row;
        }
        
        return false;
    }
    
    /**
     * Get array
     * @param type $query
     * @param type $params
     * @return boolean
     */
    public function arr($query, $params=array())
    {
        $qResult = $this->query($query, $params);

        if($qResult)
        {
            $arr = array();
            while($row  = PDOWrapper::fetch_assoc($qResult))
            {
                $arr[]  =   $row;
            }
            
            return $arr;
        }
        
        return false;
    }
}
}
