<?php

namespace MGModule\ServerAllocator\libraries\classes;
use MGModule\ServerAllocator\libraries\classes as classes;
use MGModule\ServerAllocator\libraries\classes\MG_Lang;
use MGModule\ServerAllocator\libraries\classes\MG_Validation;

class MG_AddonController
{ 
    //Warning types
    const MESSAGE_WARNING   =   'warning';
    const MESSAGE_DANGER    =   'danger';
    const MESSAGE_INFO      =   'info';
    const MESSAGE_SUCCESS   =   'success';
    
    //Addon Name
    private $addon_name =   null;
    
    //Variables Assigned To Template
    private $variables  =   array();
    
    //Smarty
    private $smarty =   null;
    
    //Lang Class
    protected $lang =   null;
    
    //Set it, if you don't want to use Reflection Class
    private $class_path = '';
    
    //Is ajax request?
    private $ajax = false;
    
    private $json = false;
    
    
    public function _init($addon_name, $class_path)
    {
        //Addon name is set?
        if(!$addon_name)
        {
            die('Cannot run! Addon name is not set');
        }
        
        //Class path is set?
        if(!$class_path)
        {
            die('Cannot run! Class path is not set');
        }
        
        //Is Ajax request?
        if(isset($_REQUEST['ajax']))
        {
            $this->ajax = true;
        }
        
        //Set up addon name
        $this->addon_name = $addon_name;
        
        //Set class path
        $this->class_path = $class_path;
        
        //Load Lang Class
        $this->lang = new MG_Lang(ROOTDIR.DS.'modules'.DS.'addons'.DS.$addon_name.DS.'lang');
        
        //Assign lang
        $this->assign('lang', $this->lang->getLang());
        
        //Database
        $this->db = new classes\MG_DB();
        
        //Validation
        $this->validation = new MG_Validation();
        
        //PRZEROBIC KIEDYS NA PHP 5.3 KURWA MAC!!!
        $this->validation->setErrorHandler(array($this, '_validationErrorHandler'));
    } 
    
    /**
     * Load Smarty Class
     * @return boolean
     */
    private function enableSmarty()
    {
        if($this->smarty)
        {
            return true;
        }
        
        if(!class_exists('\Smarty'))
        {
            if(file_exists(ROOTDIR.DS.'includes'.DS.'smarty'.DS.'Smarty.class.php'))
            {
                require_once(ROOTDIR.DS.'includes'.DS.'smarty'.DS.'Smarty.class.php');
            }
            else
            {
                die('Smarty does not exists!');
            }
        }
        
        $this->smarty = new \Smarty();
    }
    
    protected function assign($name, $value)
    {
        $this->variables[$name] = $value;
    }
    
    /**
     * Convert array to json object and set flag "json" to 1
     * @param type $jsonData
     */
    protected function json($jsonData = array())
    {
        $this->json = 1;
        echo json_encode($jsonData); 
    }
    
    protected function datatable($rows = array(), $count = 0, $filterCount = 0)
    {
        if(!empty($rows))
        {
            if(!isset($rows[0]))
            {
                $rows = array_values($rows);
            }
            
            if(!isset($rows[0][0]))
            {
                foreach($rows as &$row)
                {
                    $row = array_values($row);
                }
                unset($row);
            }
        }

        $data = array
        (
            'aaData'                =>  $rows,
            'iTotalRecords'         =>  $count,
            'iTotalDisplayRecords'  =>  $filterCount
        );
        
        $this->json($data);
    }
    
    protected function build($template_name, $variables = array())
    {
        if($variables)
        {
            foreach($variables as $key => $value)
            {
                $this->assign($key, $value);
            }
        }
        
        $extension = pathinfo($template_name, \PATHINFO_EXTENSION);
        if(!$extension)
        {
            $extension = 'tpl';
            $name = $name.'.tpl';
        }
        
        $dir = dirname($this->class_path);

        if($this->isAjax() && file_exists($dir.DIRECTORY_SEPARATOR.'views'.(WHMCS6 ? 'v6' : '').DIRECTORY_SEPARATOR.'ajax.'.$template_name))
        {
            $template_name  = 'ajax.'.$template_name;
        }
        
        if(!file_exists($dir.DIRECTORY_SEPARATOR.'views'.DIRECTORY_SEPARATOR.$template_name))
        {
            throw new \Exception('File '.$dir.DIRECTORY_SEPARATOR.'views'.(WHMCS6 ? 'v6' : '').DIRECTORY_SEPARATOR.$template_name.' does not exists');
        }
        
        $output = '';
        
        switch($extension)
        {
            case 'php':
                ob_start();
                extract($this->variables);
                include $dir.DIRECTORY_SEPARATOR.'views'.(WHMCS6 ? 'v6' : '').DIRECTORY_SEPARATOR.$template_name;
                $output = ob_get_clean();
                break;
            
            case 'tpl':
                global $templates_compiledir;
                $this->enableSmarty();
                $this->smarty->template_dir = $dir.DIRECTORY_SEPARATOR.'views'.(WHMCS6 ? 'v6' : '').DIRECTORY_SEPARATOR;
                $this->smarty->compile_dir = $templates_compiledir;
                $this->smarty->force_compile = 1;
                
                foreach($this->variables as $key => $val)
                {
                    $this->smarty->assign($key, $val);
                }
                
                $output = $this->smarty->fetch($template_name, time()); 
                break;
                
            default:
                die('Unsupported file type! ');
        }
        
        echo $output;
    }
    
    /**
     * Is Ajax?
     * @return bool
     */
    public final function isAjax()
    {
        return $this->ajax;
    }
    
    public final function isJSON()
    {
        return $this->json;
    }
    
    //It should be private but I need this function for validation ;(
    protected function setMessage($msg, $type = 'danger')
    {
        if(!in_array($type, array(self::MESSAGE_WARNING, self::MESSAGE_DANGER, self::MESSAGE_INFO, self::MESSAGE_SUCCESS)))
        {
            die('Unsupported message type!');
        }
        
        $_SESSION[$this->addon_name]['messages'][]  =   array
        (
            'type'  =>  $type,
            'msg'   =>  $msg
        );
    }
    
    public function _validationErrorHandler($params = array())
    {
        if(!$params || !is_array($params))
        {
            return false;
        }
        
        foreach($params as $err)
        { 
            $this->setMessage(str_replace("%", $this->lang->translate($err['field']), $this->lang->translate('validation_'.$err['rule'])));
        }
    }
} 