<?php
namespace MGModule\ServerAllocator\libraries\classes;

use MGModule\ServerAllocator\libraries\classes as classes;

class GetDataFromDB
{
    public static function getProduct($productid)
    {
        return (new classes\MG_DB())->row("
		SELECT h.`userid`, h.`packageid`, p.`gid` as `pgid`, p.`servertype`
		FROM `tblhosting` h
		LEFT JOIN `tblproducts` p ON (h.`packageid` = p.`id`)
		WHERE h.`id` = ?", array($productid));
    }

    public static function getProductForShoppingCartValidate($productid)
    {
        return (new classes\MG_DB())->row("
        SELECT `id`, `gid`, `name`, `servergroup`, `servertype` 
        FROM `tblproducts` 
        WHERE `id` = ?
        ", array($productid));
    }
    
    public static function getProductGroup($productid)
    {
        return (new classes\MG_DB())->row("
        SELECT `id`, `name` 
        FROM `tblproductgroups` 
        WHERE `id` = ?
        ", array($productid));
    }

    public static function getRuleGroup($pgid)
    {
       return (new classes\MG_DB())->row("
		SELECT rg.*
		FROM `serverswitcher_rulegroups` rg
		LEFT JOIN `serverswitcher_rulegroups_rel` rr 
        ON (rr.`rulegroupid` = rg.`id`)
		WHERE rr.`productgroupid` = ?
		ORDER BY rg.`order`
	    ", array($pgid));
    }

    public static function getRules($pgid)
    {
        return (new classes\MG_DB())->arr("
		SELECT r.*
		FROM `serverswitcher_rules` r
		LEFT JOIN `serverswitcher_rulegroups_rel` rr 
        ON (rr.`rulegroupid` = r.`gid`)
		WHERE rr.`productgroupid` = ?
	    ", array($pgid));
    }

    public static function getOptions($configOptionId)
    {
        return (new classes\MG_DB())->row("
        SELECT *
        FROM `tblproductconfigoptions`
        WHERE `id` = ?
        ", array($configOptionId));
    }

    public static function getField($customFieldId)
    {
        return (new classes\MG_DB())->row("
        SELECT *
        FROM `tblcustomfields`
        WHERE `id` = ?
        ", array($customFieldId));
    }

    public static function getConfigOptions($productid)
    {
        return (new classes\MG_DB())->arr("
		SELECT * FROM  `tblhostingconfigoptions` 
         WHERE `relid` = ?
	    ", array($productid));
    }

    public static function getClient($userid)
    {
        return (new classes\MG_DB())->arr("
        SELECT `id`,`firstname`,`lastname` 
        FROM  `tblclients` 
        WHERE `id` = ?
        ", array($userid));
    }

    public static function getAddons($productid)
    {
        return (new classes\MG_DB())->arr("
		SELECT * FROM `tblhostingaddons` 
        WHERE `hostingid` = ?
	    ", array($productid));
    }

    public static function getCustomFields($productid)
    {
        return (new classes\MG_DB())->arr("
		SELECT v.* FROM `tblcustomfieldsvalues` 
        v LEFT JOIN `tblcustomfields` 
        f ON (v.`fieldid` = f.`id`) 
        WHERE v.`relid` = ? 
        AND f.`type` = 'product' 
        AND v.`value` <> ''
	    ", array($productid));
    }

    public static function getServers($rule, $servertype)
    {
        return (new classes\MG_DB())->arr("
        SELECT srr.`serverid`, s.`maxaccounts`, (SELECT count(*) FROM tblhosting h WHERE h.server = s.id and h.domainstatus IN ('Active', 'Suspended')) AS `usage`
        FROM `serverswitcher_ruleservers_rel` srr
        LEFT JOIN `tblservers` s ON ( srr.`serverid` = s.`id` )
        WHERE srr.`ruleid` = ?
        AND s.`disabled` = 0
        AND s.`type`= ?
        ", array($rule, $servertype));
    }

    public static function getServerId($servertype, $dserversq)
    {
        return (new classes\MG_DB())->row("
        SELECT `id`
        FROM `tblservers`
        WHERE `maxaccounts` > `active`
        AND `id` IN (" . $dserversq . ")
        AND `type` = ?
        ORDER BY `active` DESC
        LIMIT 0,1
        ", array($servertype));
    }
}