<?php
namespace MGModule\ServerAllocator\libraries\classes;
use MGModule\ServerAllocator\libraries\classes as classes;

class CheckFields 
{
    public function checkParamsAndReturnPriority($rule, $productid, $configOptions = null, $addons = null, $fields = null, $client = null, $userid = null)
    {
        $pData = $this->getpData($productid, $userid);
        $rules = $this->prepareData($rule);
        
        $rconfigurableoptionsPass = $raddonsPass = $rcustomfieldsPass = $rclientsIdPass = false;

        $rconfigurableoptionsPass = empty($rules['rconfigurableoptions']) ? 0 : serverallocatorCheckConfigurableOptions($rules['rconfigurableoptions'], empty($configOptions) ? $pData['pconfigoptions'] : $configOptions);
        $raddonsPass = empty($rules['raddons']) ? 0 : serverallocatorCheckAddons($rules['raddons'], empty($addons) ? $pData['paddons'] : $addons);
        $rcustomfieldsPass = empty($rules['rcustomfields']) ? 0 : serverallocatorCheckCustomFields($rules['rcustomfields'], empty($fields) ? $pData['pcustomfields'] : $fields);
        $rclientsIdPass = empty($rules['rclientsId']) ? 0 :  $this->serverallocatorCheckClientsId($rules['rclientsId'], empty($client) ? $pData['pclient'] : $client );

        if(($rconfigurableoptionsPass >= 0 && $raddonsPass >= 0 && $rcustomfieldsPass >= 0 && $rclientsIdPass >= 0) && (($rconfigurableoptionsPass + $raddonsPass + $rcustomfieldsPass + $rclientsIdPass) > 0)) 
        {
            $rulespassed = array("rule" => $rule['id'], "priority" => ($rconfigurableoptionsPass + $raddonsPass + $rcustomfieldsPass + $rclientsIdPass), 'filltype' => $rules['filltype'], 'fullserver' => $rules['fullserver']);
        }
    return $rulespassed;
    }

    public function serverallocatorCheckClientsId($ruleClientId = array(), $orderClientId = array())
    {
        foreach($ruleClientId as $key => $value)
        {
            if($value == $orderClientId[0]['id'])
            {
                return 1;
            }
        }
        return -1;
    }

    public static function sortByPriority($rulespassed, $on, $order = SORT_ASC)
    {
        $newArray = array();
        $sortableArray = array();

        if ($rulespassed == null || count($rulespassed) == 0) 
        {
            return;
        }
        foreach ($rulespassed as $k => $v) {
            if (is_array($v)) {
                foreach ($v as $k2 => $v2) {
                    if ($k2 == $on) {
                        $sortableArray[$k] = $v2;
                    }
                }
            } else {
                $sortableArray[$k] = $v;
            }
        }

        switch ($order) {
            case SORT_ASC:
                asort($sortableArray);
            break;
            case SORT_DESC:
                arsort($sortableArray);
            break;
        }

        foreach ($sortableArray as $k => $v) {
            $newArray[$k] = $rulespassed[$k];
        }

        return $newArray;
    }

    private function prepareData($rule)
    {
        $rules = [
            'rconfigurableoptions' => unserialize($rule['configurableoptions']),
            'raddons' => unserialize($rule['addons']),
            'rcustomfields' => unserialize($rule['customfields']),
            'rclientsId' => json_decode($rule['clientsid']),
            'filltype' => $rule['filltype'],
            'fullserver' => $rule['fullserver']
        ];

        return $rules;
    }

    private function getpData($productid, $userid)
    {
        $data = [
            'pconfigoptions' => classes\GetDataFromDB::getConfigOptions($productid),
            'pclient' => classes\GetDataFromDB::getClient($userid),
            'paddons' => classes\GetDataFromDB::getAddons($productid),
            'pcustomfields' => classes\GetDataFromDB::getCustomFields($productid)
        ];

        return $data;
    }
}
