<?php

/* * ********************************************************************
 *  Server Switcher (5.02.15)
 * *
 *
 *  CREATED BY MODULESGARDEN       ->        http://modulesgarden.com
 *  CONTACT                        ->       contact@modulesgarden.com
 *
 *
 *
 *
 * This software is furnished under a license and may be used and copied
 * only  in  accordance  with  the  terms  of such  license and with the
 * inclusion of the above copyright notice.  This software  or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person.  No title to and  ownership of the  software is  hereby
 * transferred.
 *
 * @author Maks Aloksa  <max@modulesgarden.com>
 * 
 * new version
 * @author Andrzej Olearka <andrzej.ol@modulesgarden.com>
 *
 * ******************************************************************** */

use MGModule\ServerAllocator\libraries\classes as classes;
//error_reporting(E_ALL);
//ini_set('display_errors', 1);
defined('DS') ? false : define('DS', DIRECTORY_SEPARATOR);

if(!defined('PHP_VERSION_ID')) 
{
    $version = explode('.', PHP_VERSION);
    define('PHP_VERSION_ID', ($version[0] * 10000 + $version[1] * 100 + $version[2]));
}

//includes
include dirname(__FILE__) . DS . 'libraries' . DS . 'classes' . DS . 'class.MG_DB.php';
include dirname(__FILE__) . DS . 'libraries' . DS . 'classes' . DS . 'class.MG_Lang.php';
// include file with functions
require_once dirname(__FILE__) . DS . 'core.php';
require_once dirname(__FILE__) . DS . 'init.php';


//======================================================================
//   HOOKS
//======================================================================

function hook_serverallocator_SwitchTheServer($vars)
{
    $orderid = $vars['OrderID'];

    $db = new classes\MG_DB();

    $query    = $db->arr("SELECT `id` FROM `tblhosting` WHERE `orderid` = ?", array($orderid));
    $products = array();

    foreach($query as $row)
    {
        $products[] = $row['id'];
    }

    hook_serverallocator_SwitchServer($products);
}
add_hook('AfterShoppingCartCheckout', 1, 'hook_serverallocator_SwitchTheServer');

/**
 * Function To Switch Server For Ordered Products
 *
 *
 * @param array $products
 */
function hook_serverallocator_SwitchServer($products)
{
    if(empty($products))
    {
        return;
    }
    foreach($products as $productid)
    {
        $rules = new classes\CheckProductsRules();
        $rules->execute($productid);
    }
}


// specific for this version

add_hook('ShoppingCartValidateProductUpdate', 1, function ($vars) 
{
    foreach ($_SESSION['cart']['products'] as $index => $products) {
        $rules = new classes\CheckShoppingProdctsRules();
        $rules->execute($products);
    }
});
