<?php

use MGModule\ServerAllocator\libraries\classes as classes;

//includes
include dirname(__FILE__) . DS . 'libraries' . DS . 'classes' . DS . 'class.MG_DB.php';

function serverallocatorCheckConfigurableOptions($ruleOptions = array(), $orderOptions = array())
{
    foreach($orderOptions as $orderOption)
    {
        $id = $orderOption['configid'];

        if(isset($ruleOptions[$id]) && !empty($ruleOptions[$id]))
        {
            $ruleOption = $ruleOptions[$id];

            $optionSet = serverallocatorGetConfigOptionSet($id);

            switch($optionSet['optiontype'])
            {
                case "1": //dropdowns
                case "2": //radio
                    if($orderOption['optionid'] == $ruleOption)
                    {
                        $ruleOptions[$id] = 'pass';
                    }
                    break;
                            
                case "3": // yes/no
                    if(isset($ruleOption['check']) && $orderOption['qty'])
                    {
                        $ruleOptions[$id] = 'pass';
                    } 
                    elseif(!isset($ruleOption['check']) && !$orderOption['qty'])
                    {
                        $ruleOptions[$id] = 'pass';
                    }
                    break;
                    
                case "4": // Quantity
                    if($ruleOption['minval'] == $ruleOption['maxval'])
                    {
                        if($orderOption['qty'] == $ruleOption['minval'])
                        {
                            $ruleOptions[$id] = 'pass';
                        }
                    }
                    elseif($ruleOption['minval'] && $ruleOption['maxval'])
                    {
                        if($orderOption['qty'] >= $ruleOption['minval'] && $orderOption['qty'] <= $ruleOption['maxval'])
                        {
                            $ruleOptions[$id] = 'pass';
                        }
                    }
                    elseif($ruleOption['minval'])
                    {
                        if($orderOption['qty'] >= $ruleOption['minval'])
                        {
                            $ruleOptions[$id] = 'pass';
                        }
                    }
                    elseif($ruleOption['maxval'])
                    {
                        if($orderOption['qty'] <= $ruleOption['maxval'])
                        {
                            $ruleOptions[$id] = 'pass';
                        }
                    }

                default:
                    break;
            }
        }
    }

    $pass = false;
    foreach($ruleOptions as $key => $ispass)
    {
        if($ispass === 'pass')
        {
            $pass = true;
        }
        else
        {
            $pass = false;
            break;
        }
    }
    
    return $pass ? 1 : -1;
}

function serverallocatorCheckAddons($ruleAddons = array(), $orderAddons = array())
{
    foreach($orderAddons as $orderAddon)
    {
        $id = $orderAddon['addonid'];

        if(in_array($id, $ruleAddons))
        {
            $ruleAddons[$id] = 'pass';
        }
    }

    $pass = false;
    foreach($ruleAddons as $key => $ispass)
    {
        if($ispass === 'pass')
        {
            $pass = true;
        }else
        {
            $pass = false;
            break;
        }
    }

    return $pass ? 1 : -1;
}

function serverallocatorCheckCustomFields($ruleOptions = array(), $orderOptions = array())
{
    foreach($orderOptions as $orderOption)
    {
        $id = $orderOption['fieldid'];

        if(isset($ruleOptions[$id]) && !empty($ruleOptions[$id]))
        {
            $ruleOption = $ruleOptions[$id];

            $optionSet = serverallocatorGetCustomFieldSet($id);

            switch ($optionSet['fieldtype']) {
                case "link":
                case "password":
                case "textarea":
                    // skip
                    break;
                
                case "text":
                case "dropdown":
                    if($orderOption['value'] == $ruleOption)
                    {
                        $ruleOptions[$id] = 'pass';
                    }
                    else
                    {
                        $ruleOptions[$id] = 'failed';
                    }
                    break;
                    
                case "tickbox": // yes/no
		    if(isset($ruleOption['check']) && $ruleOption['check'] == 1 && $orderOption['value'] == "on")
                    {
                        $ruleOptions[$id] = 'pass';
		    }
                    elseif(!isset($ruleOption['check']) && ($orderOption['value'] == "off" || !$orderOption['value']))
                    {
                        $ruleOptions[$id] = 'pass';
                    }
                    else
                    {
                        $ruleOptions[$id] = 'failed';
                    }
                    break;
                    
                default:
                    break;
            }
        }
    }

    foreach($ruleOptions as $id => $ruleOption)
    {
        $optionSet = serverallocatorGetCustomFieldSet($id);

        if($optionSet['fieldtype'] == 'tickbox' && !$ruleOption['check'])
        {
            $empty = false;

            foreach($orderOptions as $orderOption)
            {
                if($orderOption['fieldid'] == $id)
                {
                    $empty = true;
                }
            }
            if($empty)
            {
                $ruleOptions[$id] = 'failed';
            }
            else
            {
                $ruleOptions[$id] = 'pass';
            }
        }

        if($optionSet['fieldtype'] == 'tickbox' && $ruleOption['check'])
        {
            $empty = false;

            foreach($orderOptions as $orderOption)
            {
                if($orderOption['fieldid'] == $id)
                {
                    $empty = true;
                }
            }
            if(!$empty)
            {
                $ruleOptions[$id] = 'failed';
            }
        }
    }

    $pass = false;
    foreach($ruleOptions as $key => $ispass)
    {
        if($ispass === 'pass')
        {
            $pass = true;
        }
        elseif($ispass === 'failed')
        {
            $pass = false;
            break;
        }
    }

    return $pass ? 1 : -1;
}

function serverallocatorGetConfigOptionSet($id)
{
    $db = new classes\MG_DB();

    $configOption = $db->row("
        SELECT *
	FROM `tblproductconfigoptions`
	WHERE `id` = ?
    ", array($id));

    $configOptionSub = $db->arr("
        SELECT *
        FROM  `tblproductconfigoptionssub`
        WHERE `configid` = ?
    ", array($id));

    $configOption['sub'] = $configOptionSub;

    return $configOption;
}

function serverallocatorGetCustomFieldSet($id)
{
    $db = new classes\MG_DB();

    $customField = $db->row("
        SELECT *
        FROM `tblcustomfields`
        WHERE `id` = ?
    ", array($id));

    return $customField;
}

function serverallocatorHelperSortByPriority($a, $b)
{
    if($a["priority"] == $b["priority"])
    {
        return 0;
    }
    
    return ($a["priority"] < $b["priority"]) ? 1 : -1;
}

function serverallocatorAllocateServer($servers, $filltype)
{
    if(empty($servers) || !in_array($filltype, [1,2]))
    {
        return array();
    }
    
    usort($servers, function ($server1, $server2)
    {
        if ($server1['usage'] === $server2['usage'])
        {
            return 0;
        }
        return ($server1['usage'] < $server2['usage']) ? -1 : 1;
    });
    
    if($filltype == 2)
    {
        $servers = array_reverse($servers);
    }
    
    foreach($servers as $server)
    {
        if($server['usage'] < $server['maxaccounts'])
        {
            return $server;
        }
    }
    
    return array();
}
