<?php

use MGModule\ServerAllocator\libraries\classes as classes;
use MGModule\ServerAllocator\libraries\classes\MG_AddonConfig;

/**********************************************************************
 *  Server Switcher 1.0.2 (28.08.14)
 * *
 *
 *  CREATED BY MODULESGARDEN       ->        http://modulesgarden.com
 *  CONTACT                        ->       contact@modulesgarden.com
 *
 *
 *
 *
 * This software is furnished under a license and may be used and copied
 * only  in  accordance  with  the  terms  of such  license and with the
 * inclusion of the above copyright notice.  This software  or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person.  No title to and  ownership of the  software is  hereby
 * transferred.
 *
 * @author Maks Aloksa  <max@modulesgarden.com>
 *
 **********************************************************************/

class ServerAllocator extends MG_AddonConfig
{
    //Module Name
    public $name = 'Server Allocator';

    //System Name
    public $system_name = 'Server Allocator';

    //Module Description
    public $description = 'This addon allows you to set server assignment rules according to selected configurable options, addons or custom fields.<br/>For more info please visit our <a href="http://www.docs.modulesgarden.com/Server_Allocator_For_WHMCS" target="_blank" style="color: #4169E1;">Wiki</a>.'; 

    //Module Version
    public $version = '1.2.0';

    //Module Author
    public $author = '<a href="http://www.modulesgarden.com" targer="_blank">ModulesGarden</a>';

    //Default Admin Controller
    public $default_admin_controller    = 'ssconfig';

    //Default Admin Method
    public $default_admin_method        =  null; //will be loaded automatically as "index"

    //Default Client Page
    public $default_client_controller   = 'main';

    //Default Client Page
    public $default_client_method       = null; //will be loaded automatically as "index"

    //Top Menu
    public $menu =  array (
        'ssconfig'             =>  array (
            'title'         =>  'Rules Configuration',
            'icon'          =>  'magic'
        ),

//        'messages'         =>  array (
//            'title'             =>  'Messages',
//            'icon'              =>  'magic',
//        ),
    );

    
    public function __construct()
    {
        parent::__construct();
        
        $versionFile = __DIR__.DIRECTORY_SEPARATOR.'moduleVersion.php';
        if(file_exists($versionFile))
        {
            $content = file_get_contents($versionFile);
            $moduleVersion = $this->findModuleVersion($content);

            if(!$moduleVersion){
                throw new \Exception('Invalid module version');
            }

            $this->version = $moduleVersion;
        }
    }

     /**
     * This function is call when administrator will configuring addon on Addons page
     */
    public function config()
    {
        $configarray = array();
        return $configarray;
    }

    /**
     * This function is call when administrator will activate your module
     */
    public function activate()
    {
        $db = new classes\MG_DB();
        $oldVersionActive = false;
        
        try
        {
            //Look for old brand in active addons list
            $activeAddons = $db->row("
                SELECT `value` FROM `tblconfiguration` WHERE `setting` = 'ActiveAddonModules'
                ",array());
            $activeAddonsList = explode(',', $activeAddons['value']);
            if(in_array('serverswitcher', $activeAddonsList))
            {
                $oldVersionActive = true;
            }

            $tableCharset = $db->query("SHOW CREATE TABLE `tblservers`");
            $tableCharset = classes\PDOWrapper::fetch_assoc($tableCharset);
            $tableCharset = explode(' ', $tableCharset['Create Table']);
            
            foreach ($tableCharset as $key => $valueCharset) {
                if(strpos($valueCharset, 'CHARSET') || strpos($valueCharset, 'CHARSET')===0){
                    $tCharset = trim($valueCharset, 'CHARSET=');
                    $charset = $tCharset && $tCharset !== '' ? $tCharset : 'utf8';
                }
                if(strpos($valueCharset, 'COLLATE') || strpos($valueCharset, 'COLLATE')===0){
                    $tColation = trim($valueCharset, 'COLLATE=');
                    $colation = $tColation && $tColation !== '' ? 'COLLATE '.$tColation : '';
                }                
            }            
            
            //create database tables
            $db->query("
                CREATE TABLE IF NOT EXISTS `serverswitcher_rulegroups` (
                    `id`                    INT(11) NOT NULL AUTO_INCREMENT,
                    `name`                  VARCHAR(50) NOT NULL,
                    `defaultservers`        TEXT NOT NULL,
                    `order`                 INT(3) NOT NULL,
                    UNIQUE KEY(`id`)
                )  DEFAULT CHARACTER SET ".$charset."  ".$colation." ENGINE = MYISAM ");

            $db->query("
                CREATE TABLE IF NOT EXISTS `serverswitcher_rulegroups_rel` (
                    `rulegroupid`           INT(11) NOT NULL,
                    `productgroupid`        INT(11) NOT NULL
                )  DEFAULT CHARACTER SET ".$charset."  ".$colation." ENGINE = MYISAM ");

            $db->query("
                CREATE TABLE IF NOT EXISTS `serverswitcher_rules` (
                    `id`                    INT(11) NOT NULL AUTO_INCREMENT,
                    `gid`                   INT(11) NOT NULL,
		    `servertype`	    VARCHAR( 100 ) NOT NULL,
                    `configurableoptions`   TEXT NOT NULL,
                    `addons`                TEXT NOT NULL,
                    `customfields`          TEXT NOT NULL,
                    `order`                 INT(3) NOT NULL,
                    `filltype`              INT(1) DEFAULT 1, 
                    `fullserver`            BOOLEAN DEFAULT 0, 
                    `clientsid`             TEXT NOT NULL, 
                    UNIQUE KEY(`id`)
                )  DEFAULT CHARACTER SET ".$charset."  ".$colation." ENGINE = MYISAM ");

            $db->query("
                CREATE TABLE IF NOT EXISTS `serverswitcher_ruleservers_rel` (
                    `ruleid`            INT(11) NOT NULL,
                    `serverid`          INT(11) NOT NULL
                )  DEFAULT CHARACTER SET ".$charset."  ".$colation." ENGINE = MYISAM ");

        }
        catch(Exception $e)
        {
            return array('status' => 'error', $e->getMessage());
        }
        
        if($oldVersionActive)
        {
            return array('status' => 'info','description'=>'Please do not deactivate the old version of the module! Instead, remove directory "serverswitcher" form '.  trim(__DIR__, 'ServerAllocator').'.');            
        }
    }

    /**
     * Functions is called when administrator will deactivate your module
     */
    public function deactivate()
    {
    /*
        $db = new MG_DB();

	try
        {
	    $db->query("DROP TABLE `serverswitcher_rulegroups`");
	    $db->query("DROP TABLE `serverswitcher_rulegroups_rel`");
	    $db->query("DROP TABLE `serverswitcher_rules`");
	    $db->query("DROP TABLE `serverswitcher_ruleservers_rel`");
	}
        catch(Exception $e)
        {
	    echo $e->getMessage();
	}
     * 
     */
    }

    public function upgrade($vars)
    { 
        $db = new classes\MG_DB();
        
        $result = $db->query("SHOW COLUMNS IN `serverswitcher_rules`");
        while($row = $result->fetch())
        {
            $existsColumns[$row['Field']] = $row['Field'];
        }
        
        if(!in_array('filltype', $existsColumns)){
            $result = $db->query("ALTER TABLE `serverswitcher_rules` ADD `filltype` INT(1) DEFAULT 1 AFTER `order`");
        }
        if(!in_array('fullserver', $existsColumns)){
            $result = $db->query("ALTER TABLE `serverswitcher_rules` ADD `fullserver` BOOLEAN DEFAULT 0 AFTER `filltype`");
        }
        if(!in_array('clientsid', $existsColumns)){
            $result = $db->query("ALTER TABLE `serverswitcher_rules` ADD `clientsid` TEXT NOT NULL AFTER `fullserver`");
        }
    }

    private function findModuleVersion($content)
    {
        $matches = [];
        preg_match('/\$moduleVersion\s?=\s?\'([A-Za-z0-9_\.\-]+)\'/', (string)$content, $matches);
        return $matches[1];
    }
}
