<?php

use MGModule\ServerAllocator\libraries\classes as classes;
use MGModule\ServerAllocator\libraries\classes\MG_AddonController;
use Respect\Validation\Rules\Length;

class ssconfig extends MG_AddonController {
    // =================================================================================
    //  pages
    // =================================================================================


    /**
     * Configuration -> Switcher Rules (Page)
     */
    public function index() {
        $vars = array();

        $prodgroups = $pservers   = $rulegroups = array();

        // add group dialog data -----------------------------------------------
        // Get product groups
        $result = $this->db->query("
            SELECT DISTINCT pg.`id` , pg.`name`
	    FROM `tblproductgroups` pg
	    LEFT JOIN `tblproducts` p ON ( pg.`id` = p.`gid` )
            LEFT JOIN `serverswitcher_rulegroups_rel` sr ON (pg.`id` = sr.`productgroupid`)
	    WHERE p.`id` IS NOT NULL AND sr.`productgroupid` IS NULL;
        ");
        while ($row    = classes\PDOWrapper::fetch_assoc($result)) {
            $prodgroups[$row['id']] = $row['name'];
        }
        unset($result);
        unset($row);
        $vars['prodgroups'] = $prodgroups;

        // get prodduct servers
        $result = $this->db->query("
            SELECT `id`, `name` FROM `tblservers`
            ORDER BY `type`
        ");
        while ($row    = classes\PDOWrapper::fetch_assoc($result)) {
            $pservers[$row['id']] = $row['name'];
        }
        unset($result);
        unset($row);
        $vars['pservers'] = $pservers;

        // rules table data ----------------------------------------------------
        // get rule groups
        $rulegroups = $this->db->arr("
            SELECT * FROM `serverswitcher_rulegroups` ORDER BY `order`
        ");
        foreach ($rulegroups as &$rulegroup) {
            $defaultservers = unserialize($rulegroup['defaultservers']);
            $rulegroup['defaultservers'] = [];
            foreach ((array)$defaultservers as $server) {
                $rulegroup['defaultservers'][] = ['id' => $server, 'name' => $pservers[$server]];
            }
            $assignedPG                  = $this->db->arr("
                SELECT r.`productgroupid` as `id`, pg.`name`
                FROM `serverswitcher_rulegroups_rel` r
                LEFT JOIN `tblproductgroups` pg ON (r.`productgroupid` = pg.`id`)
                WHERE `rulegroupid` = ?
                ", array($rulegroup['id']));
            $rulegroup['pgroups']        = $assignedPG;
        } unset($rulegroup);

        //  get rules
        $query = $this->db->query("
            SELECT *
            FROM `serverswitcher_rules`
        ");

        // get rules details
        $rules = array();
        while ($row   = classes\PDOWrapper::fetch_assoc($query)) {

            // configurableoptions ---------------------------------------------
            $row['configurableoptions'] = unserialize($row['configurableoptions']);
            if(!empty($row['configurableoptions']))
            {
                foreach ($row['configurableoptions'] as $key => &$val) {

                    $params = $this->db->row("SELECT `optionname`, `optiontype` FROM `tblproductconfigoptions` WHERE `id` = ?", array(intval($key)));
                    $value  = $this->db->row("SELECT `optionname` FROM  `tblproductconfigoptionssub` WHERE `id` = ?", array(intval($val)));
                    $val    = !is_array($val) ? array('value' => $value['optionname']) : $val;
                    $val    = array_merge($val, (array)$params);
                }
            }

            unset($val);

            // addons ----------------------------------------------------------
            $row['addons'] = unserialize($row['addons']);
            if(!empty($row['addons']))
            {
                foreach ($row['addons'] as $key => &$val) {

                    $params = $this->db->row("SELECT `name` FROM `tbladdons` WHERE `id` = ?", array(intval($val)));
                    $val    = $params;
                }
            }

            unset($val);

            // customfields ----------------------------------------------------
            $row['customfields'] = unserialize($row['customfields']);
            $customFieldsTmp = [];
            if(!empty($row['customfields']))
            {
                foreach ($row['customfields'] as $key => $val) {

                    $params = $this->getcfparams($key);
                    if(!$params)
                    {
                        continue;
                    }
                    $val    = !is_array($val) ? array('value' => $val) : $val;
                    $val    = array_merge($val, (array)$params);
                    $customFieldsTmp[$key] = $val;
                }
            }
            $row['customfields'] = $customFieldsTmp;
            unset($val);

            // clients ----------------------------------------------------
            if(!empty($row['clientsid']))
            {
                $row['clients'] = [];
                foreach(json_decode($row['clientsid']) as $key => $value)
                {
                    array_push($row['clients'], $this->db->row("SELECT `id`,`firstname`,`lastname`,`companyname` FROM `tblclients` WHERE `id` LIKE ?", array($value)));
                }
            }
            unset($row['clientsid']);
            // get servers
            $servers = $this->db->arr("
                SELECT r.`serverid`, s.`name`
                FROM `serverswitcher_ruleservers_rel` r
                LEFT JOIN `tblservers` s ON (r.`serverid` = s.`id`)
                WHERE r.`ruleid` = ?
            ", array($row['id']));

            $row['servers'] = $servers;

            $rules[$row['gid']][] = $row;
        }
        unset($row);

        $vars['rulegroups'] = $rulegroups;
        $vars['rules']      = $rules;

        $this->build('config.tpl', $vars);
    }


    /**
     *  Rules Configuration -> Add Rule (Page)
     */
    public function addrule()
    {
        $vars = array();

        $gid = $_REQUEST['gid'];
        $gid = preg_replace('/[^0-9]/', '', $gid);

        $servertype = $_REQUEST['servertype'];
        $servertype = preg_replace('/[^a-zA-Z0-9]/', '', $servertype);

        // post handler
        if ($_REQUEST['saverule']) {

            $rule    = $_REQUEST['rule'];
            $servers = $_REQUEST['servers'];

            $res = $this->saveRule($gid, $servertype, $rule, $servers);
            ob_clean();
            header("Location: addonmodules.php?module=ServerAllocator&modpage=ssconfig");
            die();
        }

        if (!isset($servertype) || $servertype == '') {

            $vars['chooseservertype'] = true;


            $vars['servertypes'] = $this->getServerTypes($gid);

            $this->build('addrule.tpl', $vars);
            return;
        }

        // get prodduct servers
        $pservers         = $this->getServers($gid, $servertype, true);
        $vars['pservers'] = $pservers;

        // get available rules
        $configOptions = $this->getConfigOptions($gid, $servertype);

        $addons       = $this->getAddons($gid, $servertype);
        $customFields = $this->getCustomFields($gid, $servertype);
        $clients      = $this->getCleintsData($gid, $servertype);
//        die(var_dump($customFields));

        $vars['configOptions'] = $configOptions;
        $vars['addons']        = $addons;
        $vars['customfilds']   = $customFields;
        $vars['clients']       = $clients;
        $vars['rule']['filltype']   = 1; //default

        $this->build('addrule.tpl', $vars);
    }


    /**
     *  Rules Configuration -> Edit Rule (Page)
     */
    public function editrule() {
        $vars         = array();
        $vars['edit'] = 1;

        $id = $_REQUEST['id'];
        $id = preg_replace('/[^0-9]/', '', $id);


        // post handler
        if ($_REQUEST['saverule']) {
            $vars['error'] = true;
            $rule    = $_REQUEST['rule'];
            $servers = $_REQUEST['servers'];

            try{
                $res = $this->updateRule($id, $rule, $servers);
            }
            catch (Exception $e){
                $vars['error'] = false;
            }
            ob_clean();

            header("Location: addonmodules.php?module=ServerAllocator&modpage=ssconfig&message={$vars['error']}");
            die();
        }

        // get rules details
        $rule = $this->db->row("SELECT * FROM `serverswitcher_rules` WHERE `id` = ?", array($id));

        $gid        = $rule['gid'];
        $servertype = $rule['servertype'];

        // configurableoptions ---------------------------------------------
        $rule['configurableoptions'] = unserialize($rule['configurableoptions']);
        if(!empty($rule['configurableoptions']))
        {
            foreach ($rule['configurableoptions'] as $key => &$val) {
                $params = $this->getcoparams($key);
                $val    = !is_array($val) ? array('value' => $val) : $val;
                $val    = array_merge($val, $params);
            }
        }

        unset($val);

        // addons ----------------------------------------------------------
        $rule['addons'] = unserialize($rule['addons']);
        if(!empty($rule['addons']))
        {
            foreach ($rule['addons'] as $key => &$val) {
                $params = $this->getaddparams($val);
                $val    = !is_array($val) ? array('value' => $val) : $val;
                $val    = array_merge($val, $params);
            }
        }

        unset($val);

        // customfields ----------------------------------------------------
        $rule['customfields'] = unserialize($rule['customfields']);
        $customFieldsTmp = [];
        if(!empty($rule['customfields']))
        {
            foreach ($rule['customfields'] as $key => $val) {
                $params = $this->getcfparams($key);
                if(!$params)
                {
                    continue;
                }
                if ($params['fieldtype'] == 'dropdown') {
                    $params['fieldoptions'] = explode(",", $params['fieldoptions']);
                }
                $val = !is_array($val) ? array('value' => $val) : $val;
                $val = array_merge($val, (array)$params);
                $customFieldsTmp[$key] = $val;
            }
        }
        $rule['customfields'] = $customFieldsTmp;
        unset($val);

        // clientsid ----------------------------------------------------

        if(!empty($rule['clientsid']))
        {
            foreach (json_decode($rule['clientsid']) as $key => $val)
            {
                $params = $this->getClientById($val);

                $rule['clients'][$key] = $params[0];
            }
        }
        unset($rule['clientsid']);
        unset($val);
        // get servers
        $result = $this->db->query("SELECT `serverid` FROM `serverswitcher_ruleservers_rel` WHERE `ruleid` = ?", array($rule['id']));

        while ($row = classes\PDOWrapper::fetch_assoc($result)) {
            $servers[] = $row['serverid'];
        }
        unset($result);
        unset($row);

        $rule['servers'] = $servers;
        unset($servers);

        $vars['rule'] = $rule;

        // get prodduct servers
        $pservers         = $this->getServers($gid, $servertype, true);
        $vars['pservers'] = $pservers;

        // get available rules
        $configOptions = $this->getConfigOptions($gid, $servertype);
        $addons        = $this->getAddons($gid, $servertype);
        $customFields  = $this->getCustomFields($gid, $servertype);
        $clients       = $this->getCleintsData($gid, $servertype);

        $vars['configOptions'] = $configOptions;
        $vars['addons']        = $addons;
        $vars['customfilds']   = $customFields;
        $vars['clients']       = $clients;

        $this->build('addrule.tpl', $vars);
    }
    // =================================================================================
    // ajax pages
    // =================================================================================
    // group operations -------------------------------------------------


    /**
     *  Configuration -> Switcher Rules -> Save Rule Group (AJAX)
     */
    public function savegroup() {

        $name = $_REQUEST['name'];
        $name = preg_replace('/[^a-zA-Z0-9_\.\s]/', '', $name);

        $groupdetails = array();

        $pgroups = $_REQUEST['groups'];
        $servers = $_REQUEST['servers'];

        $maxorder = $this->db->row("SELECT 1 + MAX(`order`) as `maxorder` FROM `serverswitcher_rulegroups`");
        $maxorder = $maxorder['maxorder'] + 1;

        $this->db->query("
            INSERT INTO `serverswitcher_rulegroups` (`name`, `defaultservers`, `order`)
            VALUES (?, ?, ?)
        ", array($name, serialize($servers), $maxorder));

        $groupid = classes\PDOWrapper::insert_id();

        $groupdetails['id']      = $groupid;
        $groupdetails['pgroups'] = array();

        foreach ($pgroups as $pgroupid) {

            $pgroupid = preg_replace('/[^0-9]/', '', $pgroupid);

            $this->db->query("
                INSERT INTO  `serverswitcher_rulegroups_rel`
                VALUES (?, ?)
            ", array($groupid, $pgroupid));

            $group                     = $this->db->row("SELECT `id`, `name` FROM `tblproductgroups` WHERE `id` = ?", array($pgroupid));
            $groupdetails['pgroups'][] = $group;
            unset($group);
        }

        foreach ($servers as &$server) {

            $server = preg_replace('/[^0-9]/', '', $server);

            $serverr = $this->db->row("SELECT `id`, `name` FROM `tblservers` WHERE `id` = ?", array($server));
            $server  = $serverr;
        }
        unset($server);

        $groupdetails['servers'] = $servers;

        $data = array('status' => 'success', 'groupdetails' => $groupdetails);

        $this->json($data);
    }


    /**
     *  Configuration -> Switcher Rules -> Delete Rule Group (AJAX)
     */
    public function delrulegroup() {
        if ($this->isAjax()) {

            $groupid = (int) preg_replace('/[^0-9]/', '', $_REQUEST['groupid']);

            $this->db->query("
                DELETE FROM `serverswitcher_rulegroups`
                WHERE `id` = ?
            ", array($groupid));

            $this->db->query("
                DELETE FROM  `serverswitcher_rulegroups_rel`
                WHERE `rulegroupid` = ?
            ", array($groupid));

            $this->db->query("
                DELETE FROM `serverswitcher_rules`
                WHERE `gid` = ?
            ", array($groupid));

            $this->db->query("
                DELETE FROM `serverswitcher_ruleservers_rel`
                WHERE `ruleid` NOT IN (SELECT `id` FROM `serverswitcher_rules`)
            ");

            $this->json(array('status' => 'success'));
        }
    }


    public function getServersAjax() {
        if ($this->isAjax()) {
            $productGroups = $_REQUEST['productGroups'];

            $productGroups = array_map(function($el) {
                return (int) preg_replace('/[^0-9]/', '', $el);
            }, $productGroups);

            $servers = $this->getServers(null, null, false, $productGroups);

            $this->json(array("options" => $servers));
            die();
        }
    }


    public function getServerTypesAjax() {
        if ($this->isAjax()) {

            $productGroups = $_REQUEST['productGroups'];

            $productGroups = array_map(function($el) {
                return (int) preg_replace('/[^0-9]/', '', $el);
            }, $productGroups);

            $servers = $this->getServerTypes(null, $productGroups);

            $this->json(array("options" => $servers));
        }
    }


    public function setSort() {
        if ($this->isAjax()) {

            $sort = preg_replace('/[^0-9]/', '', $_REQUEST['sorted']);

            foreach ($sort as $key => $gid) {
                $gid = substr($gid, 1);
                $this->db->query("UPDATE `serverswitcher_rulegroups` SET `order` = ? WHERE `id` = ?", array($key, $gid));
            }

            die("success");
        }
    }


    // new rule operations -------------------------------------------------

    public function getcoparamsAjax() {
        if ($this->isAjax()) {
            $coid = preg_replace('/[^0-9]/', '', $_REQUEST['id']);

            return $this->json($this->getcoparams($coid));
        }
    }


    public function getaddparamsAjax() {
        if ($this->isAjax()) {
            $addid = preg_replace('/[^0-9]/', '', $_REQUEST['id']);

            $this->json($this->getaddparams($addid));
        }
    }


    public function getcfparamsAjax() {
        if ($this->isAjax()) {
            $cfid = preg_replace('/[^0-9]/', '', $_REQUEST['id']);

            $this->json($this->getcfparams($cfid));
        }
    }

    public function getclientAjax() {
        (strlen($_REQUEST['term']) < 2 ) ? exit() :  $this->json($this->getClient($_REQUEST['term']));

    }
    // rules operations -------------------------------------------------

    public function delrule() {
        if ($this->isAjax()) {
            $ruleid = $_REQUEST['ruleid'];

            $this->db->query("
                DELETE FROM `serverswitcher_rules`
                WHERE `id` = ?
            ", array($ruleid));

            $this->db->query("
                DELETE FROM `serverswitcher_ruleservers_rel`
                WHERE `ruleid` = ?
            ", array($ruleid));

            $this->json(array('status' => 'success'));
        }
    }


    public function checkExistingAjax()
    {
        $gid        = (int) preg_replace('/[^0-9]/', '', $_REQUEST['gid']);
        $servertype = $_REQUEST['servertype'];
        $rule       = $_REQUEST['rule'];

        $configoptions = $rule['configoption'] ?? [];
        $addons        = $rule['addon'] ?? [];
        $customfields  = $rule['customfield'] ?? [];
        $clientsid     = $rule['clientsid'] ?? [];

        if(is_array($customfields))
        {
            krsort($configoptions);
        }
        if(is_array($addons))
        {
            krsort($addons);
        }
        if(is_array($customfields))
        {
            krsort($customfields);
        }

        $sconfigoptions = serialize($configoptions);
        $saddons        = serialize($addons);
        $scustomfields  = serialize($customfields);
        $clientsid      = serialize($clientsid);

        $rules = $this->db->arr("
            SELECT * FROM `serverswitcher_rules`
            WHERE `gid` = ? AND `servertype` = ? AND `configurableoptions` = ? AND `addons` = ? AND `customfields` = ? AND `clientsid` = ?
        ", array($gid, $servertype, $sconfigoptions, $saddons, $scustomfields, $clientsid));

        if (empty($rules)) {
            $this->json(array("status" => "success"));
        } else {
            $this->json(array("status" => "error", "msg" => "this rule exist"));
        }
    }


    function getProductsListAjax() {
        $result = $this->db->query("
                SELECT DISTINCT pg.`id` , pg.`name`
                FROM `tblproductgroups` pg
                LEFT JOIN `tblproducts` p ON ( pg.`id` = p.`gid` )
                LEFT JOIN `serverswitcher_rulegroups_rel` sr ON (pg.`id` = sr.`productgroupid`)
                WHERE p.`id` IS NOT NULL AND sr.`productgroupid` IS NULL;
            ");
        while ($row    = classes\PDOWrapper::fetch_assoc($result)) {
            $prodgroups[$row['id']] = $row['name'];
        }
        unset($result);
        unset($row);

        $this->json(array("status" => "success", "products" => $prodgroups));
    }

    // =================================================================================
    // private function (controler core)
    // =================================================================================


    private function getServers($gid = null, $servertype = '', $forceservertype = false, $productGroups = array()) {

        if (empty($productGroups)) {

            $result = $this->db->query("SELECT `productgroupid` FROM `serverswitcher_rulegroups_rel` WHERE `rulegroupid` = ?", array($gid));
            while($row = classes\PDOWrapper::fetch_assoc($result))
            {
                $productGroups[] = $row['productgroupid'];
            }
        }

        if (!empty($productGroups)) {

            $productGroups = implode(',', $productGroups);

            if (!$forceservertype) {
                $servers = $this->db->arr("
		    SELECT DISTINCT s.`id` , s.`name`
		    FROM `tblservers` s
		    LEFT JOIN `tblservergroupsrel` sr ON ( s.`id` = sr.`serverid` )
		    WHERE sr.`groupid`
		    IN (
			SELECT `servergroup`
			FROM `tblproducts`
			WHERE `gid`
			IN ( " . $productGroups . " )
			AND `servergroup` <> 0
			GROUP BY `servergroup`
		    ) "
                    . ($servertype != '' ? " AND s.`type` = '" . $servertype . "'" : "")
                );
            } else {
                $servers = $this->db->arr("
		    SELECT s.`id` , s.`name`
		    FROM `tblservers` s
		    WHERE s.`type` = '" . $servertype . "'"
                );
            }
        }

        return $servers;
    }


    private function getcoparams($coid = 0) {

        if ($coid) {

            $configOption = $this->db->row("
                    SELECT co . * , GROUP_CONCAT(CAST( p.`id` AS CHAR )SEPARATOR ', ') AS pids
                    FROM `tblproductconfigoptions` co
                    LEFT JOIN `tblproductconfiglinks` col ON ( co.`gid` = col.`gid` )
                    LEFT JOIN `tblproducts` p ON ( col.`pid` = p.`id` )
                    WHERE co.`id` = ?
                    GROUP BY co.`gid`
                ", array($coid));

            $configOptionSub = $this->db->arr("
                    SELECT *
                    FROM  `tblproductconfigoptionssub`
                    WHERE `configid` = ?
                ", array($coid));

            $configOption['sub'] = $configOptionSub;

            return $configOption;
        }

        return array();
    }


    private function getServerTypes($gid = null, $productGroups = array()) {

        if (empty($productGroups)) {
            $result = $this->db->query("SELECT `productgroupid` FROM `serverswitcher_rulegroups_rel` WHERE `rulegroupid` = ?", array($gid));
            while ($row    = classes\PDOWrapper::fetch_assoc($result)) {
                $productGroups[] = $row['productgroupid'];
            }
        }

        $productGroups = implode(',', $productGroups);

        $servers = $this->db->arr("
	    SELECT DISTINCT s.`type`
	    FROM `tblservers` s
	    LEFT JOIN `tblservergroupsrel` sr ON ( s.`id` = sr.`serverid` )
	    WHERE sr.`groupid`
	    IN (
		SELECT `servergroup`
		FROM `tblproducts`
		WHERE `gid`
		IN ( " . $productGroups . " )
		AND `servergroup` <> 0
		GROUP BY `servergroup`
	    )
	");

        return $servers;
    }


    private function getaddparams($addid = 0) {

        $paddon = $this->db->row("
                SELECT *
                FROM `tbladdons`
                WHERE `id` = ?
            ", array($addid));

        return $paddon;
    }

    private function getClient($clientName = 0) {
        if(str_contains($clientName, '#'))
        {
            $clientName = substr($clientName, 1);
        }
        $clientName = trim($clientName);
        $clientNames = explode(' ', $clientName);

        $clients = [];
        $esc = new classes\PDOWrapper;
        foreach($clientNames as $string)
        {
            $clients[] = $this->db->arr("
            SELECT `firstname`,`lastname`,`id`,`companyname`
            FROM `tblclients` 
            WHERE `firstname` LIKE '%". $esc->real_escape_string($string) ."%' OR `lastname` LIKE '%".  $esc->real_escape_string($string) ."%' OR `companyname` LIKE '%".  $esc->real_escape_string($string) ."%' OR `id` LIKE '%".  $esc->real_escape_string($string) ."%'");
        }
        // var_dump($clients[0]);
        foreach($clients[0] as $key => $client)
        {
            foreach($clientNames as $string)
            {
                $bool = false;
                foreach($client as $value)
                {
                    if(str_contains($value, ucfirst($string)))
                    {
                        $bool = true;
                    }
                }
                if (!$bool) unset($clients[0][$key]);

                $bool = false;
            }
        }
        return $clients[0];
    }

    private function getClientById($clientId = 0) {

        $clients = $this->db->arr("
                SELECT `firstname`,`lastname`,`id`,`companyname`
                FROM `tblclients` 
                WHERE `id` LIKE ?", array($clientId));
        return $clients;
    }

    private function getcfparams($cfid = 0) {

        $customField = $this->db->row("
                SELECT *
                FROM `tblcustomfields`
                WHERE `id` = ?
            ", array($cfid));

        return $customField;
    }


    private function getConfigOptions($gid, $servertype = '') {

        $pgroups = '';

        $query = $this->db->query("
            SELECT `productgroupid` FROM `serverswitcher_rulegroups_rel` WHERE `rulegroupid` = ?
        ", array($gid));

        while ($row = classes\PDOWrapper::fetch_assoc($query)) {
            $pgroups .= $row['productgroupid'] . ",";
        }
        $pgroups = substr($pgroups, 0, -1);

        $configOptions = $this->db->arr("
                SELECT co.`id`, co.`gid`, co.`optionname`, cog.`name`
                FROM `tblproductconfigoptions` co
                LEFT JOIN `tblproductconfiggroups` cog ON (co.`gid` = cog.`id`)
                LEFT JOIN `tblproductconfiglinks` col ON (co.`gid` = col.`gid`)
                LEFT JOIN `tblproducts` p ON (col.`pid` = p.`id`)
                WHERE p.`gid` IN (" . $pgroups . ")
		" . ($servertype != '' ? "AND p.`servertype` = '" . $servertype . "'" : "") . "
                GROUP BY co.`id`
                ORDER BY co.`gid`
            ");

        return $configOptions;
    }


    private function getCleintsData($gid, $servertype = '')
    {
        $clientsArray = [];

        $query = $this->db->query("
        SELECT `clientsid` FROM `serverswitcher_rules` WHERE `gid` = ?
        ", array($gid));

        $clietntsId = classes\PDOWrapper::fetch_assoc($query);

        if(empty(json_decode($clietntsId['clientsid'])))
        {
            return;
        }

        foreach (json_decode($clietntsId['clientsid']) as $key => $value)
        {
            array_push($clientsArray, $this->getClientById($value)[0]);
        }

        return $clientsArray;
    }

    private function getAddons($gid, $servertype = '') {

        $pgroups = '';

        $query = $this->db->query("
            SELECT `productgroupid` FROM `serverswitcher_rulegroups_rel` WHERE `rulegroupid` = ?
        ", array($gid));

        while ($row = classes\PDOWrapper::fetch_assoc($query)) {
            $pgroups .= $row['productgroupid'] . ",";
        }
        $pgroups = substr($pgroups, 0, -1);

        $products = $this->db->arr("SELECT `id` FROM  `tblproducts` WHERE `gid` IN (" . $pgroups . ")" . ($servertype != '' ? " AND `servertype` = '" . $servertype . "'" : ""));

        $addons = array();

        foreach($products as $product)
        {
            $productid = (int)$product['id'];

            $paddons = $this->db->arr("
                    SELECT `id`, `name`
                    FROM `tbladdons`
                    WHERE `packages` = $productid OR `packages` LIKE '$productid,%' OR `packages` LIKE '%,$productid,%' OR `packages` LIKE '%,$productid'
                ");

            foreach ($paddons as $paddon) {
                if (!in_array($paddon, $addons)) {
                    $addons[] = $paddon;
                }
            }
        }

        return $addons;
    }


    private function getCustomFields($gid, $servertype = '') {
        $customFields = $this->db->arr("
                    SELECT cf.`id`, cf.`fieldname`, p.`name` as productname
                    FROM `tblcustomfields` cf
                    JOIN `tblproducts` p ON (cf.`relid` = p.`id`)
                    JOIN `serverswitcher_rulegroups_rel` sr ON (sr.`productgroupid` = p.`gid`)
                    WHERE sr.`rulegroupid` = ? AND cf.`type` = 'product' ".(!empty($servertype) ? "AND `servertype` = ?" : "")."
                    AND cf.`fieldtype` NOT IN ('password', 'textarea', 'link')
                    ORDER BY p.`id`
                ", !empty($servertype) ? array($gid, $servertype) : array($gid));

        return $customFields;
    }


    /**
     * Function Save Rule
     *
     * @param int $gid Rule Group ID
     * @param array $rule Rule Definitions array
     * @param array $servers Servers array
     */
    private function saveRule($gid, $servertype, $rule, $servers)
    {
        $configoptions = $rule['configoption']  ?? [];
        $addons        = $rule['addon']  ?? [];
        $customfields  = $rule['customfield']  ?? [];
        $filltype      = $rule['filltype'];
        $fullserver    = $rule['fullserver'];
        $clientsid     = $rule['clientsid']  ?? [];
        $clientArray   = [];
        foreach($clientsid as $clientid)
        {
            array_push($clientArray, $clientid);
        }
        $clientArray = json_encode($clientArray);

        if(is_array($customfields))
        {
            krsort($configoptions);
        }
        if(is_array($addons))
        {
            krsort($addons);
        }
        if(is_array($customfields))
        {
            krsort($customfields);
        }

        $sconfigoptions = serialize($configoptions);
        $saddons        = serialize($addons);
        $scustomfields  = serialize($customfields);

        $maxorder = $this->db->row("SELECT MAX(`order`) as `maxorder` FROM  `serverswitcher_rules` WHERE `gid` = ?", array($gid));
        $maxorder = ((int) $maxorder['maxorder']) + 1;

        $this->db->query("
            INSERT INTO `serverswitcher_rules` (`gid`, `servertype`, `configurableoptions`, `addons`, `customfields`, `order`, `filltype`, `fullserver`, `clientsid`)
            VALUES (?,?,?,?,?,?,?,?,?)
        ", array($gid, $servertype, $sconfigoptions, $saddons, $scustomfields, $maxorder, $filltype, $fullserver ?: '0', $clientArray));
        $ruleid = classes\PDOWrapper::insert_id();
        foreach ($servers as $serverid) {
            $this->db->query("
                INSERT INTO `serverswitcher_ruleservers_rel`
                VALUES (?,?)
            ", array($ruleid, $serverid));
        }
    }


    /**
     * Function Update Rule
     *
     * @param int $id Rule ID
     * @param array $rule Rule Definitions array
     * @param array $servers Servers array
     */
    private function updateRule($id, $rule, $servers)
    {
        $configoptions = $rule['configoption'] ?? [];
        $addons        = $rule['addon'] ?? [];
        $customfields  = $rule['customfield'] ?? [];
        $filltype      = $rule['filltype'];
        $fullserver    = $rule['fullserver'] ?: '0';
        $clientsId     = $rule['clientsid'] ?? [];
        $clients       = [];

        foreach($clientsId as $client)
        {
            array_push($clients, $client);
        }
        $clientArray = json_encode($clients);

        if(is_array($clients))
        {
            krsort($clients);
        }
        if(is_array($customfields))
        {
            krsort($configoptions);
        }
        if(is_array($addons))
        {
            krsort($addons);
        }
        if(is_array($customfields))
        {
            krsort($customfields);
        }

        $sconfigoptions = serialize($configoptions);
        $saddons        = serialize($addons);
        $scustomfields  = serialize($customfields);

        $this->db->query("
            UPDATE `serverswitcher_rules`
	    SET `configurableoptions` = ?, `addons` = ?, `customfields` = ?, `filltype` = ?, `fullserver` = ?, `clientsid` = ?
            WHERE `id` = ?
        ", array($sconfigoptions, $saddons, $scustomfields, $filltype, $fullserver, $clientArray, $id));

        $this->db->query("DELETE FROM `serverswitcher_ruleservers_rel` WHERE `ruleid` = ?", array($id));

        foreach ($servers as $serverid) {
            $this->db->query("
                INSERT INTO `serverswitcher_ruleservers_rel`
                VALUES (?,?)
            ", array($id, $serverid));
        }
    }

    public function editrulegroup()
    {
        $gid = $_REQUEST['gid'];
        $gid = preg_replace('/[^0-9]/', '', $gid);

        $productGroups = [];
        $result = $this->db->query("
            SELECT `productgroupid` FROM `serverswitcher_rulegroups_rel`
            WHERE `rulegroupid` = ?
        ", [$gid]);
        while ($row = classes\PDOWrapper::fetch_assoc($result))
        {
            $productGroups[] = $row['productgroupid'];
        }

        $result = $this->db->query("
            SELECT DISTINCT pg.`id` , pg.`name`
	    FROM `tblproductgroups` pg
	    LEFT JOIN `tblproducts` p ON ( pg.`id` = p.`gid` )
            LEFT JOIN `serverswitcher_rulegroups_rel` sr ON (pg.`id` = sr.`productgroupid`)
        ");
        while ($row    = classes\PDOWrapper::fetch_assoc($result)) {
            $prodgroups[$row['id']]['name'] = $row['name'];
            if(in_array($row['id'], $productGroups))
            {
                $prodgroups[$row['id']]['selected'] = true;
            }
        }
        unset($result);
        unset($row);

        $servers = $this->getServers(null, null, false, $productGroups);

        $rulegroup = $this->db->row("
            SELECT * FROM `serverswitcher_rulegroups`
            WHERE `id` = $gid
        ");

        $defaultservers = unserialize($rulegroup['defaultservers']);
        foreach ($defaultservers as $server) {
            $serverr = $this->db->row("SELECT `id` FROM `tblservers` WHERE `id` = ?", array($server));
            $vars['defaultservers'][] = $serverr['id'];
        }

        $vars['defaultservers'] = $defaultservers;
        $vars['pservers'] = $servers;
        $vars['gid'] = $gid;
        $vars['prodgroups'] = $prodgroups;
        $vars['gname'] = $rulegroup['name'];

        $this->build('editrulegroup.tpl', $vars);
    }

    public function saveeditrulegroup()
    {
        $servers = serialize($_REQUEST['servers']);
        $gid = (int) $_REQUEST['gid'];
        $name = $_REQUEST['name'];

        $this->db->query("UPDATE `serverswitcher_rulegroups` SET `defaultservers` = ?, `name` = ? WHERE `id` = ?", array($servers, $name, $gid));

        $data = new StdClass;
        $data->status = 'success';

        header('Content-Type: application/json');
        echo json_encode($data);
        exit;
    }
}
