<?php

use MGModule\ServerAllocator\libraries\classes\MG_AddonController;
use MGModule\ServerAllocator\libraries\classes as classes;


class links extends MG_AddonController {

    // =================================================================================
    //  pages
    // =================================================================================

    public function index() {
	$vars = array();

	$id = $_REQUEST['id'];
	$id = preg_replace('/[^0-9]/', '', $id);

	if(!isset($id)) {
	    ob_clean();
	    header("Location: addonmodules.php?module=ServerAllocator&modpage=ssconfig");
	    die();
	}
	// get WHMCS Config
	$CONFIG = array();
	$query = $this->db->arr("SELECT *  FROM `tblconfiguration` WHERE `setting` IN ('SystemSSLURL','SystemURL')");
	foreach($query as $row) {
	    $CONFIG[$row['setting']] = $row['value'];
	}
	// get rules details
	$rule = $this->db->row("SELECT * FROM `serverswitcher_rules` WHERE `id` = ?", array($id));

	$gid = $rule['gid'];

	$rule['configurableoptions'] = unserialize($rule['configurableoptions']);
	$rule['addons'] = unserialize($rule['addons']);
	$rule['customfields'] = unserialize($rule['customfields']);


	// get products
	$products = $this->getProducts($id);

	foreach($products as &$product) {

	    $link = "&";
	    
	    $configurableoptions = $this->getConfigOptions($product['id']);
	    $addons = $this->getAddons($product['id']);
	    $customfields = $this->getCustomFields($product['id']);

	    // configurableoptions ---------------------------------------------
	    if(!empty($rule['configurableoptions']) && !empty($configurableoptions)) {
		foreach($rule['configurableoptions'] as $key => $val) {
		    if(in_array(array("id" => $key), $configurableoptions)) {
			if(is_array($val)) {

			    if($val['minval']) {
				$link .= 'configoption[' . $key . ']=' . $val['minval'] . '&';
			    } elseif($val['maxval']) {
				$link .= 'configoption[' . $key . ']=' . $val['maxval'] . '&';
			    } elseif($val['check']) {
				$link .= 'configoption[' . $key . ']=1&';
			    }
			} else {
			    $link .= 'configoption[' . $key . ']=' . $val . '&';
			}
		    }
		}
	    }
	    // addons ----------------------------------------------------------
	    if(!empty($rule['addons']) && !empty($addons)) {
		foreach($rule['addons'] as $key => $val) {
		    if(in_array(array("id" => $key), $addons)) {
			$link .= 'addons[' . $key . ']=1&';
		    }
		}
	    }
	    // customfields ----------------------------------------------------
	    if(!empty($rule['customfields']) && !empty($customfields)) {
		foreach($rule['customfields'] as $key => $val) {
		    if(in_array(array("id" => $key), $customfields)) {
			if(is_array($val)) {
			    if($val['check']) {
				$link .= 'customfield[' . $key . ']=on&';
			    }
			} else {
			    $link .= 'customfield[' . $key . ']=' . $val . '&';
			}
		    }
		}
	    }
	    
	    $link = substr($link, 0, -1);
	    $product['link'] = $link;
	}
	
	$vars['server'] = $CONFIG["SystemSSLURL"] ? $CONFIG["SystemSSLURL"] : $CONFIG["SystemURL"];
        $vars['server'] = trim($vars['server'],'/').'/';
	$vars['products'] = $products;

	$this->build('links.tpl', $vars);
    }

    private function getProducts($ruleid) {

	$products = $this->db->arr("
	    SELECT p.`id`, p.`name`
	    FROM `tblproducts` p
	    LEFT JOIN `serverswitcher_rulegroups_rel` rr ON (p.`gid` = rr.`productgroupid`)
	    LEFT JOIN `serverswitcher_rules` r ON (rr.`rulegroupid` = r.`gid` AND p.`servertype` = r.`servertype`)
	    WHERE r.`id` = ?
	", array($ruleid));

	return $products;
    }

    private function getConfigOptions($pid) {

	$configOptions = $this->db->arr("
                SELECT co.`id`
                FROM `tblproductconfigoptions` co
                LEFT JOIN `tblproductconfiglinks` col ON (co.`gid` = col.`gid`)
                WHERE col.`pid` = ?
                GROUP BY co.`id`
                ORDER BY co.`gid`
            ", array($pid));

	return $configOptions;
    }

    private function getAddons(int $pid) {
        $esc = new classes\PDOWrapper;

		$addons = $this->db->arr("
			SELECT `id`
			FROM `tbladdons`
			WHERE `packages` = " . $esc->real_escape_string($pid) . " OR `packages` LIKE '" . $esc->real_escape_string($pid) . "%' OR `packages` LIKE '%" . $esc->real_escape_string($pid) . "%' OR `packages` LIKE '" . $esc->real_escape_string($pid) . "?'
			");

		return $addons;
    }

    private function getCustomFields($pid) {

	$customFields = $this->db->arr("
            SELECT cf.`id`
            FROM `tblcustomfields` cf
            LEFT JOIN `tblproducts` p ON (cf.`relid` = p.`id`)
            WHERE cf.`relid` = ? AND cf.`type` = 'product'
            AND cf.`fieldtype` NOT IN ('password', 'textarea', 'link')
        ", array(intval($pid)));

	return $customFields;
    }

}
