<?php

//Define Addon Dir
$ADDON_DIR = substr(dirname(__FILE__), 0, strrpos(dirname(__FILE__), 'core'));

//Get Addon Name
$ADDON_NAME = basename(substr(dirname(__FILE__), 0, strrpos(dirname(__FILE__), 'core')));

//Assets Dir
$ASSETS_DIR = '';

//Module URL
$MODULE_URL = 'addonmodules.php?module='.$_GET['module'];

//Is Client Area?
$IS_CLIENT_AREA = false;

if(basename($_SERVER['PHP_SELF'], '.php') == 'index' && isset($_REQUEST['m']))
{
    $IS_CLIENT_AREA = true;
}

//Get Controller And Method
$CONTROLLER_NAME    =   $_REQUEST['modpage'] ? preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST['modpage']) : '';
$METHOD_NAME        =   $_REQUEST['modsubpage'] ? preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST['modsubpage']) : '';

//Set Default Controller
if($CONTROLLER_NAME == '')
{
    $CONTROLLER_NAME    =   $IS_CLIENT_AREA ? $MGC->default_client_controller : $MGC->default_admin_controller;
}

//Set Default Method
if($METHOD_NAME == '')
{
    $METHOD_NAME        =   $IS_CLIENT_AREA ? $MGC->default_client_method : $MGC->default_admin_method;
    if($METHOD_NAME == '')
    {
        $METHOD_NAME = 'index';
    }
}

$moddir = '';
if($IS_CLIENT_AREA)
{
    $moddir     =   $ADDON_DIR.'clientarea'.DS;
    $ASSETS_DIR =   'modules'.DS.'addons'.DS.$ADDON_NAME.DS.'core'.DS.'assets';
}
else
{
    $moddir     =   $ADDON_DIR.'adminarea'.DS;
    $ASSETS_DIR =   '..'.DS.'modules'.DS.'addons'.DS.$ADDON_NAME.DS.'core'.DS.'assets';
}

if(!file_exists($moddir.$CONTROLLER_NAME.DS.$CONTROLLER_NAME.'.php'))
{
    die('Cannot locate controller file.'. $moddir.$CONTROLLER_NAME.DS.$CONTROLLER_NAME.'.php');
}

require_once $moddir.$CONTROLLER_NAME.DS.$CONTROLLER_NAME.'.php';
if(!class_exists($CONTROLLER_NAME))
{
    die('Cannot locate class '.$CONTROLLER_NAME.' in '.$moddir.DS.$CONTROLLER_NAME.DS.$CONTROLLER_NAME.'.php');
}

//Create Controller Class
$CONTROLLER = new $CONTROLLER_NAME();
//Run init
$CONTROLLER->init($ADDON_NAME, $moddir.$CONTROLLER_NAME.DS.$CONTROLLER_NAME.'.php');

if(!method_exists($CONTROLLER, $METHOD_NAME))
{
    die('Cannot call method '.$METHOD_NAME.'. Method doest not exists in class '.$CONTROLLER_NAME.' in '.$moddir.$CONTROLLER_NAME.DS.$CONTROLLER_NAME.'.php');
}

if(in_array($METHOD_NAME, array('setMessage', 'setAddonName', 'init')))
{
    die('Cannot run this function!');
}


if(isset($_REQUEST['ajax']) && $_REQUEST['ajax'] == 1)
{
    ob_clean();
    $CONTROLLER->$METHOD_NAME();
    ob_end_flush();
    die();
}
else
{ 
    //Get Output
    ob_start();
    $CONTROLLER->$METHOD_NAME();
    $CONTENT = ob_get_clean();
    
    //Get Addon Messages;
    $MESSAGES = $_SESSION[$ADDON_NAME]['messages'];
    $_SESSION[$ADDON_NAME]['messages']  =   null;
    
    if($IS_CLIENT_AREA)
    {
        include dirname(__FILE__).DS.'output_client.php';
    }
    else
    {
        include dirname(__FILE__).DS.'output.php';
    }
}


/*
var_dump($CONTOLLER);

echo '<pre>';
print_r($_REQUEST);
die();

define('CORE_DIR', dirname(__FILE__));
//GET ROOT DIR 
$ROOT_DIR = dirname(__FILE__);
$ROOT_DIR = substr($ROOT_DIR, 0, strrpos($ROOT_DIR, DS));
$ROOT_DIR = substr($ROOT_DIR, strrpos($ROOT_DIR, DS), strlen($ROOT_DIR));


//SOME USEFUL STUFF
require_once CORE_DIR.DS.'functions.php';
//PAGINATION INTERFACE
require_once CORE_DIR.DS.'class.MG_Pagination.php';
//MG_Langs
require_once CORE_DIR.DS.'class.MG_Lang.php';
//Validation class
require_once CORE_DIR.DS.'class.MG_Validation.php';
//Include ModulesGarden class
require_once CORE_DIR.DS.'class.ModulesGarden.php';

//INCLUDE USER FUNCTIONS IF FILE EXISTS
if(file_exists(ADDON_DIR.DS.'core.php'))
{
    require_once ADDON_DIR.DS.'core.php';
}
//GET MODULE NAME
$module = ModulesGarden::getModuleClass(ADDON_DIR.DS.$ROOT_DIR);
//CREATE MODULE CONFIG
$MGC = new $module();
//DEFINE MODULE NAME
define('ADDON_NAME', $module);

//ENABLE DEBUG
if(isset($_GET['debug']) && $_GET['debug'] == 1)
{
    $_SESSION['MODULESGARDEN_DEBUG'] = 1;
}

//DISABLE DEBUG
if(isset($_GET['debug']) && $_GET['debug'] == 0)
{
    $_SESSION['MODULESGARDEN_DEBUG'] = 0;
}

if((isset($_SESSION['MODULESGARDEN_DEBUG']) && $_SESSION['MODULESGARDEN_DEBUG']) || $MGC->debug)
{
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
}

//IS AJAX?
$AJAX = isset($_REQUEST['ajax']) ? 1 : 0;

//FIND PAGE FILES
$PAGE = isset($_REQUEST['modpage']) ? $_REQUEST['modpage'] : ($IS_CLIENTAREA ? $MGC->default_client_page : $MGC->default_page);
if($AJAX)
{
    $PAGE_FILE = 'ajax.pages'.DS.$PAGE . '.php';
}
elseif($IS_CLIENTAREA)
{
    $PAGE_FILE = 'pages_client'.DS.$PAGE.'.php';
}
else
{
    $PAGE_FILE = 'pages'.DS.$PAGE.'.php';
}
//IS IT AJAX REQUEST? JUST INCLUDE CONTROLLER FILE AND VIEW
if($AJAX)
{
    //PAGINATION REQUEST?
    if($_REQUEST['pagination'] == 1)
    {
        
        $p = new MG_Pagination($_REQUEST['parent']);
        if(isset($_REQUEST['get']))
        {
            echo $p->getPagination();
            die();
        }
        elseif(isset($_REQUEST['order_by']))
        {
            $p->setOrderBy($_REQUEST['order_by'], 'ASC');
        }
        if(isset($_REQUEST['check']))
        {
            echo json_encode(array
            (
                'next'      =>  $p->isNext(),
                'prev'      =>  $p->isPrev(),
                'current'   =>  $p->getCurrentPage(),
            ));
            die();
        } 
        elseif(isset($_REQUEST['reset']))
        {
            $p->resetFilter();
        }
        elseif(isset($_REQUEST['next']))
        {
            $p->next();
        }
        elseif(isset($_REQUEST['prev']))
        {
            $p->prev();
        }
        elseif(isset($_REQUEST['page']))
        {
            $p->setPage($_REQUEST['page']);
        }
        else
        {
            foreach($_REQUEST['filters'] as $field_name => $field_value)
            {
                if($field_value)
                {
                    $p->addFilter($field_name, $field_value);
                }
                else
                {
                    $p->removeFilter($field_name);
                }
                $p->setPage(0);
            }
        }
        //$p->resetFilter();
        $p->__destruct();
    }
    require_once ADDON_DIR.DS.$PAGE_FILE;
    if(file_exists(ADDON_DIR.DS.'ajax.views'.DS.$PAGE.'.php'))
    {
        include_once ADDON_DIR.DS.'ajax.views'.DS.$PAGE.'.php';
    }
    exit;
}
 * 
 * 
 */ 